<?php
/**
 * Plugin Name: Dima Social Share - اشتراک‌گذاری اجتماعی
 * Plugin URI: https://dimawidget.ir
 * Description: دکمه‌های اشتراک‌گذاری در شبکه‌های اجتماعی. این افزونه دکمه‌های زیبا برای اشتراک‌گذاری در تلگرام، واتساپ، اینستاگرام و... اضافه می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-social-share
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Social_Share {
    
    public function __construct() {
        add_filter('the_content', [$this, 'add_share_buttons']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_styles']);
    }
    
    /**
     * Enqueue styles
     */
    public function enqueue_styles() {
        wp_add_inline_style('wp-block-library', '
            .dima-social-share {
                margin: 30px 0;
                padding: 20px;
                background: #f9fafb;
                border-radius: 10px;
                text-align: center;
            }
            .dima-social-share h4 {
                margin-bottom: 15px;
                color: #1f2937;
                font-size: 18px;
            }
            .dima-share-buttons {
                display: flex;
                justify-content: center;
                gap: 10px;
                flex-wrap: wrap;
            }
            .dima-share-btn {
                display: inline-flex;
                align-items: center;
                padding: 10px 20px;
                border-radius: 8px;
                text-decoration: none;
                color: white;
                font-weight: 600;
                transition: transform 0.2s;
            }
            .dima-share-btn:hover {
                transform: translateY(-2px);
                color: white;
            }
            .dima-share-btn i {
                margin-left: 8px;
            }
            .dima-share-telegram { background: #0088cc; }
            .dima-share-whatsapp { background: #25D366; }
            .dima-share-twitter { background: #1DA1F2; }
            .dima-share-facebook { background: #1877F2; }
            .dima-share-linkedin { background: #0077b5; }
        ');
    }
    
    /**
     * Add share buttons to content
     */
    public function add_share_buttons($content) {
        if (!is_single()) {
            return $content;
        }
        
        global $post;
        $url = urlencode(get_permalink());
        $title = urlencode(get_the_title());
        $excerpt = urlencode(wp_trim_words(get_the_excerpt(), 20));
        
        $output = '<div class="dima-social-share">';
        $output .= '<h4>اشتراک‌گذاری در شبکه‌های اجتماعی</h4>';
        $output .= '<div class="dima-share-buttons">';
        
        // Telegram
        $output .= '<a href="https://t.me/share/url?url=' . $url . '&text=' . $title . '" target="_blank" class="dima-share-btn dima-share-telegram">';
        $output .= '<i class="fab fa-telegram"></i> تلگرام';
        $output .= '</a>';
        
        // WhatsApp
        $output .= '<a href="https://wa.me/?text=' . $title . '%20' . $url . '" target="_blank" class="dima-share-btn dima-share-whatsapp">';
        $output .= '<i class="fab fa-whatsapp"></i> واتساپ';
        $output .= '</a>';
        
        // Twitter
        $output .= '<a href="https://twitter.com/intent/tweet?url=' . $url . '&text=' . $title . '" target="_blank" class="dima-share-btn dima-share-twitter">';
        $output .= '<i class="fab fa-twitter"></i> توییتر';
        $output .= '</a>';
        
        // Facebook
        $output .= '<a href="https://www.facebook.com/sharer/sharer.php?u=' . $url . '" target="_blank" class="dima-share-btn dima-share-facebook">';
        $output .= '<i class="fab fa-facebook"></i> فیسبوک';
        $output .= '</a>';
        
        // LinkedIn
        $output .= '<a href="https://www.linkedin.com/shareArticle?url=' . $url . '&title=' . $title . '" target="_blank" class="dima-share-btn dima-share-linkedin">';
        $output .= '<i class="fab fa-linkedin"></i> لینکدین';
        $output .= '</a>';
        
        $output .= '</div>';
        $output .= '</div>';
        
        return $content . $output;
    }
}

new Dima_Social_Share();