<?php
/**
 * Plugin Name: Dima Related Posts - مطالب مرتبط
 * Plugin URI: https://dimawidget.ir
 * Description: نمایش مطالب مرتبط در انتهای پست‌ها. این افزونه مطالب مرتبط را بر اساس دسته‌بندی و تگ‌ها نمایش می‌دهد و به بهبود SEO کمک می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-related-posts
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Related_Posts {
    
    public function __construct() {
        add_filter('the_content', [$this, 'add_related_posts']);
        add_action('wp_enqueue_scripts', [$this, 'enqueue_styles']);
    }
    
    /**
     * Enqueue styles
     */
    public function enqueue_styles() {
        wp_add_inline_style('wp-block-library', '
            .dima-related-posts {
                margin-top: 40px;
                padding-top: 30px;
                border-top: 2px solid #e5e7eb;
            }
            .dima-related-posts h3 {
                font-size: 24px;
                margin-bottom: 20px;
                color: #1f2937;
            }
            .dima-related-posts-grid {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
                gap: 20px;
            }
            .dima-related-post-item {
                background: #f9fafb;
                padding: 15px;
                border-radius: 8px;
                transition: transform 0.2s;
            }
            .dima-related-post-item:hover {
                transform: translateY(-3px);
                box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            }
            .dima-related-post-item a {
                text-decoration: none;
                color: #1f2937;
                font-weight: 600;
            }
            .dima-related-post-item a:hover {
                color: #667eea;
            }
        ');
    }
    
    /**
     * Add related posts to content
     */
    public function add_related_posts($content) {
        if (!is_single() || !is_main_query()) {
            return $content;
        }
        
        global $post;
        $related = $this->get_related_posts($post->ID, 3);
        
        if (empty($related)) {
            return $content;
        }
        
        $output = '<div class="dima-related-posts">';
        $output .= '<h3>مطالب مرتبط</h3>';
        $output .= '<div class="dima-related-posts-grid">';
        
        foreach ($related as $related_post) {
            $output .= '<div class="dima-related-post-item">';
            $output .= '<a href="' . get_permalink($related_post->ID) . '">';
            $output .= '<h4>' . get_the_title($related_post->ID) . '</h4>';
            if (has_post_thumbnail($related_post->ID)) {
                $output .= get_the_post_thumbnail($related_post->ID, 'thumbnail', ['style' => 'width: 100%; height: auto; border-radius: 5px; margin-bottom: 10px;']);
            }
            $output .= '<p style="font-size: 14px; color: #6b7280; margin-top: 10px;">' . wp_trim_words(get_the_excerpt($related_post->ID), 15) . '</p>';
            $output .= '</a>';
            $output .= '</div>';
        }
        
        $output .= '</div>';
        $output .= '</div>';
        
        return $content . $output;
    }
    
    /**
     * Get related posts
     */
    private function get_related_posts($post_id, $limit = 3) {
        $categories = wp_get_post_categories($post_id);
        $tags = wp_get_post_tags($post_id, ['fields' => 'ids']);
        
        $args = [
            'post_type' => 'post',
            'posts_per_page' => $limit,
            'post__not_in' => [$post_id],
            'orderby' => 'rand'
        ];
        
        if (!empty($categories)) {
            $args['category__in'] = $categories;
        }
        
        if (!empty($tags)) {
            $args['tag__in'] = $tags;
        }
        
        $query = new WP_Query($args);
        return $query->posts;
    }
}

new Dima_Related_Posts();