jQuery(function($){
  var $drawer   = $('#dacp-drawer');
  var $overlay  = $('#dacp-overlay');
  var $btn      = $('.dacp-btn');

  function open(){
    $drawer.addClass('open').attr('aria-hidden','false');
    $overlay.removeClass('hidden').addClass('show');
    $btn.attr('aria-expanded','true');
  }
  function close(){
    $drawer.removeClass('open').attr('aria-hidden','true');
    $overlay.removeClass('show').addClass('hidden');
    $btn.attr('aria-expanded','false');
  }

  $(document).on('click','.dacp-btn', function(e){ e.preventDefault(); open(); });
  $(document).on('click','.dacp-close, #dacp-overlay', function(e){ e.preventDefault(); close(); });
  $(document).on('keydown', function(e){ if(e.key==='Escape'){ close(); } });

  // Update count after Woo fragments
  function updateCount(){
    var sum = 0;
    $('#dacp-drawer .woocommerce-mini-cart .quantity').each(function(){
      var m = String($(this).text()).match(/(\d+)/); if(m) sum += parseInt(m[1],10);
    });
    if(!isNaN(sum)) $('.dacp-badge').text(sum);
  }
  $(document.body).on('wc_fragments_refreshed wc_fragments_loaded updated_wc_div added_to_cart removed_from_cart', updateCount);
});


