// اجرای فوری قبل از document ready برای intercept کردن form submission
(function() {
    'use strict';
    
    // بررسی اینکه آیا در صفحه تک محصول هستیم - اگر هستیم، AJAX را غیرفعال می‌کنیم
    var body = document.body;
    var isSingleProduct = body && body.classList.contains('single-product');
    
    // اگر در صفحه تک محصول هستیم، handler را اضافه نکن
    if (isSingleProduct) {
        return;
    }
    
    // Handler برای form submission - با استفاده از capture phase
    document.addEventListener('submit', function(e) {
        var form = e.target;
        
        // بررسی اینکه آیا form است و کلاس cart دارد
        if (!form || form.tagName !== 'FORM' || !form.classList.contains('cart')) {
            return;
        }
        
        // اگر form مربوط به variable product است و variation انتخاب نشده، اجازه بده submit شود
        if (form.classList.contains('variations_form')) {
            var variationInput = form.querySelector('input[name="variation_id"]');
            if (!variationInput || !variationInput.value || variationInput.value === '') {
                return; // اجازه بده form submit شود برای نمایش خطا
            }
        }
        
        // جلوگیری از submit
        e.preventDefault();
        e.stopImmediatePropagation();
        
        console.log('Form submit prevented, will use Ajax');
        
        // استفاده از jQuery اگر موجود باشد، در غیر این صورت از vanilla JS
        if (typeof jQuery !== 'undefined') {
            var $form = jQuery(form);
            var $button = $form.find('.single_add_to_cart_button, button[type="submit"]');
            if ($button.length) {
                setTimeout(function() {
                    $button.trigger('click');
                }, 10);
            }
        } else {
            // Fallback: منتظر بمان تا jQuery لود شود
            setTimeout(function() {
                if (typeof jQuery !== 'undefined') {
                    var $form = jQuery(form);
                    var $button = $form.find('.single_add_to_cart_button, button[type="submit"]');
                    if ($button.length) {
                        $button.trigger('click');
                    }
                }
            }, 100);
        }
        
        return false;
    }, true); // استفاده از capture phase
    
})();

jQuery(function($){
    console.log('DACP Cart JS loaded');
    
    // بررسی اینکه آیا در صفحه تک محصول هستیم - اگر هستیم، AJAX add to cart را غیرفعال می‌کنیم
    var isSingleProduct = (typeof dacpAjax !== 'undefined' && dacpAjax.is_single_product) || 
                          $('body').hasClass('single-product');
    
    // اضافه کردن loader به body (همیشه)
    if (!$('#dacp-loader').length) {
        $('body').append('<div id="dacp-loader" class="dacp-loader-overlay"><div class="dacp-spinner"></div></div>');
    }
    
    // اگر در صفحه تک محصول هستیم، فقط AJAX add to cart را غیرفعال می‌کنیم
    // اما handlers برای حذف و کم و زیاد باید همیشه فعال باشند
    if (isSingleProduct) {
        console.log('DACP: Single product page detected, AJAX add to cart disabled');
        // فقط از اینجا return نمی‌کنیم - handlers برای cart باید کار کنند
    } else {
        console.log('DACP: Shop/Archive page detected, AJAX enabled');
    }
    
    // مودال موفقیت از PHP اضافه می‌شود، فقط بررسی می‌کنیم که وجود دارد
    
    // بررسی اینکه آیا ووکامرس loaded شده
    if (typeof wc_add_to_cart_params === 'undefined') {
        console.warn('wc_add_to_cart_params not found, using fallback');
    }
    
    if (typeof dacpAjax === 'undefined') {
        console.warn('dacpAjax not found');
    }
    
    // توابع نمایش/مخفی loader
    function showLoader() {
        $('#dacp-loader').addClass('show');
    }
    
    function hideLoader() {
        $('#dacp-loader').removeClass('show');
    }
    
    // متغیر برای نگهداری تایمر بستن خودکار مودال
    var modalAutoCloseTimer = null;
    
    // توابع نمایش/مخفی مودال موفقیت
    function showSuccessModal() {
        var $modal = $('#dacp-success-modal');
        
        // اگر مودال وجود نداشت، ایجاد کن (fallback)
        if (!$modal.length) {
            var cartUrl = (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.cart_url) 
                ? wc_add_to_cart_params.cart_url 
                : '/cart/';
            
            var modalHTML = '<div id="dacp-success-modal">' +
                '<div id="dacp-success-modal-overlay"></div>' +
                '<div id="dacp-success-modal-content">' +
                    '<div class="dacp-success-icon">' +
                        '<svg fill="none" stroke="currentColor" viewBox="0 0 24 24">' +
                            '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>' +
                        '</svg>' +
                    '</div>' +
                    '<h3 class="dacp-success-title">محصول با موفقیت اضافه شد!</h3>' +
                    '<p class="dacp-success-message">محصول به سبد خرید شما اضافه شد</p>' +
                    '<div class="dacp-success-buttons">' +
                        '<button type="button" class="dacp-success-btn dacp-success-btn-cart" data-cart-url="' + cartUrl + '">مشاهده سبد خرید</button>' +
                        '<button type="button" class="dacp-success-btn dacp-success-btn-continue dacp-success-close">ادامه خرید</button>' +
                    '</div>' +
                '</div>' +
            '</div>';
            $('body').append(modalHTML);
            $modal = $('#dacp-success-modal');
        }
        
        // به‌روزرسانی URL سبد خرید در صورت تغییر
        var cartUrl = (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.cart_url) 
            ? wc_add_to_cart_params.cart_url 
            : '/cart/';
        $modal.find('.dacp-success-btn-cart').attr('data-cart-url', cartUrl);
        
        $modal.addClass('show');
        
        // پاک کردن تایمر قبلی اگر وجود داشت
        if (modalAutoCloseTimer) {
            clearTimeout(modalAutoCloseTimer);
            modalAutoCloseTimer = null;
        }
        
        // بستن خودکار بعد از 5 ثانیه (5000 میلی‌ثانیه)
        modalAutoCloseTimer = setTimeout(function() {
            hideSuccessModal();
            modalAutoCloseTimer = null;
        }, 5000);
    }
    
    function hideSuccessModal() {
        var $modal = $('#dacp-success-modal');
        
        // پاک کردن تایمر در صورت وجود
        if (modalAutoCloseTimer) {
            clearTimeout(modalAutoCloseTimer);
            modalAutoCloseTimer = null;
        }
        
        $modal.removeClass('show');
    }
    
    // Event listeners برای بستن مودال و رفتن به سبد خرید
    $(document).on('click', '#dacp-success-modal-overlay, .dacp-success-close', function(e) {
        e.preventDefault();
        // پاک کردن تایمر چون کاربر خودش مودال را بست
        if (modalAutoCloseTimer) {
            clearTimeout(modalAutoCloseTimer);
            modalAutoCloseTimer = null;
        }
        hideSuccessModal();
    });
    
    $(document).on('click', '.dacp-success-btn-cart', function(e) {
        e.preventDefault();
        // پاک کردن تایمر چون کاربر تصمیم گرفت به سبد خرید برود
        if (modalAutoCloseTimer) {
            clearTimeout(modalAutoCloseTimer);
            modalAutoCloseTimer = null;
        }
        var cartUrl = $(this).data('cart-url') || (typeof wc_add_to_cart_params !== 'undefined' ? wc_add_to_cart_params.cart_url : '/cart/');
        window.location.href = cartUrl;
    });
    
    // بستن با کلید Escape
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape' && $('#dacp-success-modal').hasClass('show')) {
            // پاک کردن تایمر چون کاربر خودش مودال را بست
            if (modalAutoCloseTimer) {
                clearTimeout(modalAutoCloseTimer);
                modalAutoCloseTimer = null;
            }
            hideSuccessModal();
        }
    });
    
    // ============================================
    // افزودن به سبد خرید با AJAX (سازگار با ووکامرس)
    // ============================================
    
    // جلوگیری از form submission برای محصولات ساده - با priority بالا
    // فقط در صفحات shop/archive (نه در صفحه تک محصول)
    if (!isSingleProduct) {
        $(document).on('submit', 'form.cart:not(.variations_form)', function(e) {
            console.log('Form submit intercepted for simple product');
            
            var $form = $(this);
            var $button = $form.find('.single_add_to_cart_button, button[type="submit"]');
            
            // اگر دکمه کلاس product_type_variable یا product_type_grouped دارد، اجازه بده form submit شود
            if ($button.hasClass('product_type_variable') || $button.hasClass('product_type_grouped')) {
                console.log('Variable or grouped product, allowing normal submit');
                return true;
            }
            
            // جلوگیری از submit عادی
            e.preventDefault();
            e.stopImmediatePropagation();
        
        console.log('Preventing form submit, triggering Ajax add to cart');
        
        // اجرای Ajax add to cart
        if ($button.length) {
            $button.trigger('click');
        } else {
            // اگر دکمه پیدا نشد، خودمان Ajax را اجرا کنیم
            var productId = $form.find('input[name="add-to-cart"]').val();
            var quantity = $form.find('input[name="quantity"]').val() || 1;
            
            if (productId) {
                console.log('Manually triggering Ajax for product:', productId);
                // اجرای Ajax مستقیم
                var ajaxData = {
                    product_id: productId,
                    quantity: quantity
                };
                
                if (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.security) {
                    ajaxData.security = wc_add_to_cart_params.security;
                }
                
                var ajaxUrl = (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.wc_ajax_url) 
                    ? wc_add_to_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart')
                    : (typeof dacpAjax !== 'undefined' && dacpAjax.wc_ajax_url)
                        ? dacpAjax.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart')
                        : (typeof wc_add_to_cart_params !== 'undefined' ? wc_add_to_cart_params.ajax_url : (typeof dacpAjax !== 'undefined' ? dacpAjax.ajaxurl : '/wp-admin/admin-ajax.php'));
                
                if (!ajaxData.action && ajaxUrl.indexOf('admin-ajax.php') > -1) {
                    ajaxData.action = 'woocommerce_ajax_add_to_cart';
                }
                
                $.ajax({
                    url: ajaxUrl,
                    type: 'POST',
                    data: ajaxData,
                    success: function(response) {
                        console.log('Manual Ajax response:', response);
                        if (response.fragments) {
                            $.each(response.fragments, function(key, value) {
                                var $target = $(key);
                                if ($target.length) {
                                    $target.replaceWith(value);
                                }
                            });
                        }
                        $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash]);
                        updateCartCount();
                        setTimeout(function() {
                            openDrawer();
                        }, 300);
                    },
                    error: function(xhr, status, error) {
                        console.error('Manual Ajax error:', error);
                        alert('خطا در افزودن به سبد خرید');
                    }
                });
            }
        }
        
        return false;
        });
    }
    
    // برای محصولات ساده - استفاده از selector های مختلف
    // فقط در صفحات shop/archive (نه در صفحه تک محصول)
    if (!isSingleProduct) {
        $(document).on('click', '.add_to_cart_button:not(.product_type_variable):not(.product_type_grouped), .single_add_to_cart_button:not(.product_type_variable):not(.product_type_grouped), button[data-product_id]:not(.product_type_variable):not(.product_type_grouped), form.cart:not(.variations_form) .single_add_to_cart_button:not(.product_type_variable)', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $button   = $(this);
        var $form     = $button.closest('form');
        
        // دریافت product_id از چند منبع
        var productId = $button.data('product_id') || 
                       $button.attr('data-product_id') || 
                       $button.val() ||
                       ($form.length ? $form.find('input[name="add-to-cart"]').val() : null) ||
                       ($form.length ? $form.find('input[name="product_id"]').val() : null);
        
        // تبدیل به عدد
        productId = parseInt(productId);
        
        var quantity  = 1;
        
        // دریافت تعداد از form یا data attribute
        if ($form.length) {
            var $qtyInput = $form.find('input[name="quantity"], input.qty');
            if ($qtyInput.length) {
                quantity = parseInt($qtyInput.val()) || 1;
            }
        } else {
            quantity = $button.data('quantity') || 1;
        }
        
        if (!productId || isNaN(productId)) {
            console.error('Product ID not found:', {
                button: $button,
                form: $form,
                data_product_id: $button.data('product_id'),
                attr_product_id: $button.attr('data-product_id'),
                button_val: $button.val(),
                form_input: $form.length ? $form.find('input[name="add-to-cart"]').val() : null
            });
            return true; // اگر product_id نداشت، به صورت عادی کار کند
        }
        
        // جلوگیری از کلیک مکرر
        if ($button.hasClass('loading') || $button.hasClass('disabled')) {
            return false;
        }
        
        $button.addClass('loading').addClass('disabled').addClass('adding');
        
        // استفاده از endpoint استاندارد ووکامرس
        // handler استاندارد WooCommerce فقط product_id را می‌گیرد
        var ajaxData = {
            product_id: productId,
            quantity:   quantity
        };
        
        // اگر security موجود بود اضافه کن
        if (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.security) {
            ajaxData.security = wc_add_to_cart_params.security;
        }
        
        // استفاده از wc_ajax_url برای endpoint استاندارد
        var ajaxUrl;
        if (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.wc_ajax_url) {
            ajaxUrl = wc_add_to_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart');
        } else if (typeof dacpAjax !== 'undefined' && dacpAjax.wc_ajax_url) {
            ajaxUrl = dacpAjax.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart');
        } else {
            // Fallback به admin-ajax
            ajaxUrl = (typeof wc_add_to_cart_params !== 'undefined' ? wc_add_to_cart_params.ajax_url : (typeof dacpAjax !== 'undefined' ? dacpAjax.ajaxurl : '/wp-admin/admin-ajax.php'));
            ajaxData.action = 'woocommerce_ajax_add_to_cart';
        }
        
        console.log('AJAX URL:', ajaxUrl);
        console.log('AJAX Data:', ajaxData);
        
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: ajaxData,
            success: function(response) {
                console.log('Add to cart response:', response);
                
                // بررسی redirect
                if (response.redirect) {
                    window.location = response.redirect;
                    return;
                }
                
                // بررسی خطا (هم success: false و هم error)
                if (response.success === false || response.error) {
                    var errorMsg = (response.data && response.data.message) ? response.data.message : (response.message || 'خطا در افزودن به سبد خرید');
                    alert(errorMsg);
                    $button.removeClass('loading').removeClass('disabled');
                    return;
                }
                
                // تریگر استاندارد ووکامرس
                if (response.fragments) {
                    $.each(response.fragments, function(key, value) {
                        var $target = $(key);
                        if ($target.length) {
                            $target.replaceWith(value);
                        } else {
                            // اگر المنت وجود نداشت، اضافه کن
                            $(document.body).append(value);
                        }
                    });
                }
                
                // تریگر رویدادهای استاندارد ووکامرس
                $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $button]);
                $(document.body).trigger('wc_fragment_refresh');
                $(document.body).trigger('wc_fragments_refreshed');
                
                // به‌روزرسانی شمارنده
                updateCartCount();
                
                // نمایش مودال موفقیت
                showSuccessModal();
                
                // باز کردن drawer بعد از بستن مودال
                // setTimeout(function() {
                //     openDrawer();
                // }, 300);
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('خطا در افزودن به سبد خرید. لطفا دوباره تلاش کنید.');
            },
            complete: function() {
                $button.removeClass('loading').removeClass('disabled').removeClass('adding');
            }
        });
        
        return false;
        });
    }
    
    // جلوگیری از form submission برای محصولات متغیر (بعد از انتخاب variation)
    // فقط در صفحات shop/archive (نه در صفحه تک محصول)
    if (!isSingleProduct) {
        $(document).on('submit', 'form.cart.variations_form', function(e) {
        var $form = $(this);
        var $button = $form.find('.single_add_to_cart_button, button[type="submit"]');
        var variationId = $form.find('input[name="variation_id"]').val();
        
        // اگر variation انتخاب نشده، اجازه بده form submit شود (برای نمایش خطا)
        if (!variationId || variationId === '') {
            return true;
        }
        
        // جلوگیری از submit عادی
        e.preventDefault();
        e.stopPropagation();
        
        // اجرای Ajax add to cart
        $button.trigger('click');
        
        return false;
        });
    }
    
    // برای محصولات متغیر (variable products) - استفاده از selector های مختلف
    // فقط در صفحات shop/archive (نه در صفحه تک محصول)
    if (!isSingleProduct) {
    $(document).on('click', '.add_to_cart_button.product_type_variable, .single_add_to_cart_button.product_type_variable, button.product_type_variable[data-product_id], form.cart.variations_form .single_add_to_cart_button', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $button   = $(this);
        var $form     = $button.closest('form.variations_form');
        var productId = $button.data('product_id') || $form.data('product_id') || $form.find('input[name="product_id"]').val() || $form.find('input[name="add-to-cart"]').val();
        
        if (!productId || !$form.length) {
            return true; // اگر form نداشت، به صورت عادی کار کند
        }
        
        // بررسی اینکه variation انتخاب شده است
        var variationId = $form.find('input[name="variation_id"]').val() || $form.find('input.variation_id').val();
        variationId = parseInt(variationId) || 0;
        
        console.log('Variation ID from form:', variationId);
        console.log('Form inputs:', $form.find('input[name="variation_id"], input.variation_id'));
        
        if (!variationId || variationId === 0) {
            alert('لطفا گزینه‌های محصول را انتخاب کنید');
            return false;
        }
        
        // جلوگیری از کلیک مکرر
        if ($button.hasClass('loading') || $button.hasClass('disabled')) {
            return false;
        }
        
        $button.addClass('loading').addClass('disabled').addClass('adding');
        
        // دریافت quantity
        var quantity = 1;
        var $qtyInput = $form.find('input[name="quantity"]');
        if ($qtyInput.length) {
            quantity = parseInt($qtyInput.val()) || 1;
        }
        
        // دریافت variation attributes (با prefix attribute_)
        var variation = {};
        $form.find('select[name^="attribute_"], input[name^="attribute_"]:checked').each(function() {
            var $input = $(this);
            var name = $input.attr('name'); // نگه داشتن attribute_ prefix
            variation[name] = $input.val();
        });
        
        // استفاده از endpoint استاندارد ووکامرس
        // handler استاندارد WooCommerce فقط product_id را می‌گیرد
        // اگر variation_id موجود است، آن را به عنوان product_id ارسال می‌کنیم
        // این باعث می‌شود که WooCommerce خودش variation attributes را از variation product بگیرد
        var ajaxData = {
            product_id: variationId > 0 ? variationId : productId,
            quantity:   quantity
        };
        
        // برای اطمینان، variation attributes را هم ارسال می‌کنیم (اگر handler استاندارد نیاز داشته باشد)
        // اما handler استاندارد WooCommerce این را نمی‌خواهد، فقط product_id کافی است
        
        // اگر security موجود بود اضافه کن
        if (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.security) {
            ajaxData.security = wc_add_to_cart_params.security;
        }
        
        // استفاده از wc_ajax_url برای endpoint استاندارد
        var ajaxUrl;
        if (typeof wc_add_to_cart_params !== 'undefined' && wc_add_to_cart_params.wc_ajax_url) {
            ajaxUrl = wc_add_to_cart_params.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart');
        } else if (typeof dacpAjax !== 'undefined' && dacpAjax.wc_ajax_url) {
            ajaxUrl = dacpAjax.wc_ajax_url.toString().replace('%%endpoint%%', 'add_to_cart');
        } else {
            // Fallback به admin-ajax
            ajaxUrl = (typeof wc_add_to_cart_params !== 'undefined' ? wc_add_to_cart_params.ajax_url : (typeof dacpAjax !== 'undefined' ? dacpAjax.ajaxurl : '/wp-admin/admin-ajax.php'));
            ajaxData.action = 'woocommerce_ajax_add_to_cart';
        }
        
        console.log('AJAX URL (variable):', ajaxUrl);
        console.log('AJAX Data (variable):', ajaxData);
        console.log('Variation ID:', variationId);
        console.log('Variation attributes:', variation);
        
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: ajaxData,
            success: function(response) {
                console.log('Add to cart response (variable):', response);
                
                // بررسی redirect
                if (response.redirect) {
                    window.location = response.redirect;
                    return;
                }
                
                // بررسی خطا (هم success: false و هم error)
                if (response.success === false || response.error) {
                    var errorMsg = (response.data && response.data.message) ? response.data.message : (response.message || 'خطا در افزودن به سبد خرید');
                    alert(errorMsg);
                    $button.removeClass('loading').removeClass('disabled').removeClass('adding');
                    return;
                }
                
                // تریگر استاندارد ووکامرس
                if (response.fragments) {
                    $.each(response.fragments, function(key, value) {
                        var $target = $(key);
                        if ($target.length) {
                            $target.replaceWith(value);
                        } else {
                            // اگر المنت وجود نداشت، اضافه کن
                            $(document.body).append(value);
                        }
                    });
                }
                
                // تریگر رویدادهای استاندارد ووکامرس
                $(document.body).trigger('added_to_cart', [response.fragments, response.cart_hash, $button]);
                $(document.body).trigger('wc_fragment_refresh');
                $(document.body).trigger('wc_fragments_refreshed');
                
                // به‌روزرسانی شمارنده
                updateCartCount();
                
                // نمایش مودال موفقیت
                showSuccessModal();
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                alert('خطا در افزودن به سبد خرید. لطفا دوباره تلاش کنید.');
            },
            complete: function() {
                $button.removeClass('loading').removeClass('disabled').removeClass('adding');
            }
        });
        
        return false;
        });
    }
    
    // باز و بسته کردن drawer
    function openDrawer(){
        $('#dacp-drawer').addClass('open').attr('aria-hidden','false');
        $('#dacp-overlay').removeClass('hidden').addClass('show');
        $('.dacp-btn').attr('aria-expanded','true');
        // $('body').addClass('overflow-hidden');
    }
    
    function closeDrawer(){
        $('#dacp-drawer').removeClass('open').attr('aria-hidden','true');
        $('#dacp-overlay').removeClass('show').addClass('hidden');
        $('.dacp-btn').attr('aria-expanded','false');
        // $('body').removeClass('overflow-hidden');
    }
    
    // Event listeners برای باز/بسته کردن
    $(document).on('click', '.dacp-btn', function(e){ 
        e.preventDefault(); 
        openDrawer(); 
    });
    
    $(document).on('click', '.dacp-close, #dacp-overlay', function(e){ 
        e.preventDefault(); 
        closeDrawer(); 
    });
    
    $(document).on('keydown', function(e){ 
        if(e.key === 'Escape'){ 
            closeDrawer(); 
        }
    });
    
    // ============================================
    // حذف محصول از سبد خرید
    // ============================================
    $(document).on('click', '.dima-remove-item, .remove, a[data-cart-key]', function(e){
        e.preventDefault();
        e.stopPropagation();
        
        var $button = $(this);
        var $item   = $button.closest('.dima-cart-item, .woocommerce-cart-form__cart-item, tr.cart_item');
        
        // دریافت cart key از خود دکمه یا از parent
        var cartKey = $button.attr('data-cart-key') || 
                     $button.data('cart-key') ||
                     $button.attr('data-product_id') ||
                     $button.data('product_id');
        
        if (!cartKey && $item.length) {
            cartKey = $item.attr('data-cart-key') || 
                     $item.data('cart-key') ||
                     $item.find('input[name*="cart"]').val();
        }
        
        // اگر هنوز cart key پیدا نشد، از href دکمه بگیر
        if (!cartKey && $button.attr('href')) {
            var hrefMatch = $button.attr('href').match(/remove_item=([^&]+)/);
            if (hrefMatch) {
                cartKey = decodeURIComponent(hrefMatch[1]);
            }
        }
        
        console.log('Removing item with cart key:', cartKey);
        console.log('Button:', $button);
        console.log('Item:', $item);
        
        if (!cartKey) {
            console.error('Cart key not found on button or item');
            console.log('Button:', $button);
            console.log('Item:', $item);
            alert('خطا: کلید سبد خرید پیدا نشد');
            return;
        }
        
        // جلوگیری از کلیک مکرر
        if ($button.hasClass('removing')) {
            return;
        }
        
        $button.addClass('removing');
        
        // نمایش loader
        showLoader();
        if ($item.length) {
            $item.addClass('loading');
        }
        
        // بررسی اینکه dacpAjax موجود است
        if (typeof dacpAjax === 'undefined') {
            console.error('dacpAjax is not defined');
            alert('خطا: تنظیمات AJAX یافت نشد');
            return;
        }
        
        $.ajax({
            url: dacpAjax.ajaxurl || '/wp-admin/admin-ajax.php',
            type: 'POST',
            dataType: 'json',
            data: {
                action:   'dacp_remove_item',
                cart_key: cartKey,
                nonce:    dacpAjax.nonce || ''
            },
            success: function(response) {
                console.log('Remove response:', response);
                
                // برای UX بهتر، همون لحظه آیتم رو محو کن
                if ($item.length) {
                    $item.slideUp(200, function(){
                        $(this).remove();
                    });
                }
                
                // اگر fragments برگشت، همین‌جا جایگزین کن
                if (response && response.fragments) {
                    $.each(response.fragments, function(key, value) {
                        var $target = $(key);
                        if ($target.length) {
                            $target.replaceWith(value);
                        }
                    });
                }
                
                // تریگر رویدادهای استاندارد ووکامرس
                $(document.body).trigger('removed_from_cart', [response.fragments, response.cart_hash, $button]);
                $(document.body).trigger('wc_fragment_refresh');
                $(document.body).trigger('wc_fragments_refreshed');
                
                // به‌روزرسانی شمارنده
                updateCartCount();
                
                // اگر سبد خالی شد، drawer را ببند
                if (response && response.fragments && response.fragments['.dima-cart-items']) {
                    var $cartItems = $(response.fragments['.dima-cart-items']);
                    if ($cartItems.find('.dima-cart-item').length === 0) {
                        setTimeout(function() {
                            closeDrawer();
                        }, 500);
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                console.log('Response:', xhr.responseText);
                alert('خطا در حذف محصول. صفحه را رفرش می‌کنیم...');
                setTimeout(function() {
                    location.reload();
                }, 1000);
            },
            complete: function() {
                // مخفی کردن loader
                setTimeout(function() {
                    hideLoader();
                    $button.removeClass('removing');
                    if ($item.length) {
                        $item.removeClass('loading');
                    }
                }, 300);
            }
        });
    });
    
    // ============================================
    // کاهش تعداد محصول
    // ============================================
    $(document).on('click', '.dima-decrease-qty', function(e){
        e.preventDefault();
        e.stopPropagation();
        
        var $item       = $(this).closest('.dima-cart-item');
        var cartKey     = $(this).data('cart-key');
        var $qtyElement = $item.find('.dima-item-qty');
        var currentQty  = parseInt($qtyElement.text()) || 1;
        var newQty      = Math.max(0, currentQty - 1);
        
        if (!cartKey) {
            console.error('Cart key not found');
            return;
        }
        
        updateQuantity(cartKey, newQty, $qtyElement, $item);
    });
    
    // افزایش تعداد محصول
    $(document).on('click', '.dima-increase-qty', function(e){
        e.preventDefault();
        e.stopPropagation();
        
        var $item       = $(this).closest('.dima-cart-item');
        var cartKey     = $(this).data('cart-key');
        var $qtyElement = $item.find('.dima-item-qty');
        var currentQty  = parseInt($qtyElement.text()) || 1;
        var newQty      = currentQty + 1;
        
        if (!cartKey) {
            console.error('Cart key not found');
            return;
        }
        
        updateQuantity(cartKey, newQty, $qtyElement, $item);
    });
    
// تابع به‌روزرسانی تعداد (جدید)
function updateQuantity(cartKey, quantity, $qtyElement, $item) {
    // بررسی اینکه dacpAjax موجود است
    if (typeof dacpAjax === 'undefined') {
        console.error('dacpAjax is not defined');
        alert('خطا: تنظیمات AJAX یافت نشد');
        return;
    }
    
    showLoader();
    $item.addClass('loading');

    $.ajax({
        url: dacpAjax.ajaxurl || '/wp-admin/admin-ajax.php',
        type: 'POST',
        dataType: 'json',
        data: {
            action:   'dacp_update_qty',
            cart_key: cartKey,
            quantity: quantity,
            nonce:    dacpAjax.nonce || ''
        },
        beforeSend: function () {
            // تعداد را همان لحظه عوض می‌کنیم
            $qtyElement.text(quantity);
        },
        success: function (response) {
            console.log('Update response:', response);

            if (response && response.fragments) {
                // جایگزینی تمام fragments
                $.each(response.fragments, function(key, value) {
                    var $target = $(key);
                    if ($target.length) {
                        $target.replaceWith(value);
                    }
                });

                // ۱) آپدیت subtotal همان ردیف از HTML جدید
                if (response.fragments['.dima-cart-items']) {
                    // کل html جدید را موقتاً می‌ریزیم توی یک div
                    var $tmp     = $('<div>').html(response.fragments['.dima-cart-items']);
                    // آیتمی که cart_key یکسان دارد
                    var $newItem = $tmp.find('.dima-cart-item[data-cart-key="' + cartKey + '"]');
                    
                    if ($newItem.length) {
                        // اگر آیتم هنوز وجود دارد، subtotal را آپدیت کن
                        var newSub = $newItem.find('.dima-item-subtotal').html();
                        var newQty = $newItem.find('.dima-item-qty').html();
                        
                        if (newSub) {
                            $item.find('.dima-item-subtotal').html(newSub);
                        }
                        if (newQty) {
                            $qtyElement.html(newQty);
                        }
                    } else {
                        // اگر آیتم حذف شده (تعداد صفر شد)، آن را حذف کن
                        $item.slideUp(200, function() {
                            $(this).remove();
                        });
                    }
                }

                // ۲) آپدیت جمع کل پایین
                if (response.fragments['.dima-cart-total']) {
                    $('.dima-cart-total').replaceWith(response.fragments['.dima-cart-total']);
                }

                // ۳) آپدیت badge تعداد آیتم‌ها
                if (response.fragments['.cart-counter-badge']) {
                    $('.cart-counter-badge').replaceWith(response.fragments['.cart-counter-badge']);
                }

                // تریگر رویدادهای استاندارد ووکامرس
                $(document.body).trigger('updated_wc_div');
                $(document.body).trigger('wc_fragment_refresh');
                $(document.body).trigger('wc_fragments_refreshed');

                // ۴) برای اطمینان، یک‌بار هم شمارنده داخلی را به‌روز کن
                updateCartCount();

            } else if (response && response.success === false) {
                console.error('Error:', response.data);
                alert(response.data && response.data.message ? response.data.message : 'خطا در به‌روزرسانی تعداد');
                // در صورت خطا، رفرش
                location.reload();
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX Error:', status, error);
            console.log('Response:', xhr.responseText);
            location.reload();
        },
        complete: function () {
            setTimeout(function () {
                hideLoader();
                $item.removeClass('loading');
            }, 300);
        }
    });
}
// به‌روزرسانی شمارنده سبد خرید (badge بالا)
function updateCartCount(){
    var sum = 0;

    // شمارش تعداد محصولات موجود در سبد
    $('.dima-item-qty').each(function(){
        var qty = parseInt($(this).text()) || 0;
        sum += qty;
    });

    var $badges = $('.cart-counter-badge');

    if (sum <= 0) {
        // اگر سبد خالیه: badge رو مخفی کن و مقدارش صفر باشه
        $badges.addClass('hidden').text('0');
    } else {
        // اگر محصول داره: badge رو نشون بده و انیمیشن پالس اجرا کن
        $badges
            .removeClass('hidden')
            .text(sum)
            .addClass('dacp-badge-pulse'); // اضافه شدن کلاس انیمیشن

        // بعد از نیم‌ثانیه انیمیشن تموم می‌شه → کلاس رو بردار تا آماده‌ی اجرا بعدی بشه
        setTimeout(function(){
            $badges.removeClass('dacp-badge-pulse');
        }, 550);
    }

    console.log('Cart count updated:', sum);
}
    
    // گوش دادن به رویدادهای استاندارد ووکامرس برای به‌روزرسانی خودکار
    $(document.body).on('added_to_cart removed_from_cart updated_wc_div', function(event, fragments, cart_hash) {
        if (fragments) {
            $.each(fragments, function(key, value) {
                var $target = $(key);
                if ($target.length) {
                    $target.replaceWith(value);
                }
            });
        }
        updateCartCount();
    });
    
    // گوش دادن به رویدادهای fragment refresh
    $(document.body).on('wc_fragment_refresh wc_fragments_refreshed wc_fragments_loaded', function() {
        updateCartCount();
    });
    
    // به‌روزرسانی اولیه شمارنده بعد از لود صفحه
    $(document).ready(function() {
        updateCartCount();
    });
});