jQuery(function($){
    function openDrawer(){
        $('.dima-acp-overlay').addClass('show');
        $('#dima-acp-drawer').addClass('open').attr('aria-hidden','false');
        $('.dima-acp-btn').attr('aria-expanded','true');
        $('body').addClass('overflow-hidden');
    }
    function closeDrawer(){
        $('.dima-acp-overlay').removeClass('show');
        $('#dima-acp-drawer').removeClass('open').attr('aria-hidden','true');
        $('.dima-acp-btn').attr('aria-expanded','false');
        $('body').removeClass('overflow-hidden');
    }
    $(document).on('click','.dima-acp-btn',function(e){ e.preventDefault(); openDrawer(); });
    $(document).on('click','.dima-acp-close, .dima-acp-overlay',function(e){ e.preventDefault(); closeDrawer(); });
    $(document).on('keydown',function(e){ if(e.key==='Escape'){ closeDrawer(); }});

    function refreshCount(){
        var c = 0;
        $('.widget_shopping_cart_content .quantity').each(function(){
            var m = String($(this).text()).match(/(\d+)/); if(m) c += parseInt(m[1],10);
        });
        if(!isNaN(c)) $('.dima-acp-count').text(c);
    }
    $(document.body).on('wc_fragments_refreshed wc_fragments_loaded updated_wc_div added_to_cart removed_from_cart', refreshCount);
});


