<?php
/**
 * Plugin Name: Dima Content Blocks - بلوک‌های محتوا
 * Plugin URI: https://dimawidget.ir
 * Description: بلوک‌های آماده برای صفحه‌آرایی بهتر. این افزونه بلوک‌های زیبا برای نمایش محتوا، آمار، گالری و... اضافه می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-content-blocks
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Content_Blocks {
    
    public function __construct() {
        add_action('init', [$this, 'register_blocks']);
        add_shortcode('dima_stats', [$this, 'stats_block']);
        add_shortcode('dima_quote', [$this, 'quote_block']);
        add_shortcode('dima_highlight', [$this, 'highlight_block']);
    }
    
    /**
     * Register Gutenberg blocks
     */
    public function register_blocks() {
        if (function_exists('register_block_type')) {
            register_block_type('dima/stats', [
                'render_callback' => [$this, 'stats_block']
            ]);
        }
    }
    
    /**
     * Stats block shortcode
     */
    public function stats_block($atts) {
        $atts = shortcode_atts([
            'number' => '100',
            'label' => 'مشتری',
            'icon' => 'fa-users',
            'color' => 'blue'
        ], $atts);
        
        return '<div class="dima-stat-box" style="text-align: center; padding: 20px; background: #f5f5f5; border-radius: 10px;">
            <i class="fas ' . esc_attr($atts['icon']) . '" style="font-size: 40px; color: ' . esc_attr($atts['color']) . '; margin-bottom: 10px;"></i>
            <div style="font-size: 32px; font-weight: bold; color: ' . esc_attr($atts['color']) . ';">' . esc_html($atts['number']) . '</div>
            <div style="color: #666; margin-top: 5px;">' . esc_html($atts['label']) . '</div>
        </div>';
    }
    
    /**
     * Quote block shortcode
     */
    public function quote_block($atts, $content = '') {
        $atts = shortcode_atts([
            'author' => '',
            'color' => 'purple'
        ], $atts);
        
        $output = '<blockquote class="dima-quote" style="border-right: 4px solid ' . esc_attr($atts['color']) . '; padding: 20px; background: #f9f9f9; margin: 20px 0; border-radius: 5px;">';
        $output .= '<p style="font-size: 18px; line-height: 1.8; color: #333;">' . do_shortcode($content) . '</p>';
        if (!empty($atts['author'])) {
            $output .= '<cite style="display: block; margin-top: 10px; color: #666; font-style: normal;">— ' . esc_html($atts['author']) . '</cite>';
        }
        $output .= '</blockquote>';
        
        return $output;
    }
    
    /**
     * Highlight block shortcode
     */
    public function highlight_block($atts, $content = '') {
        $atts = shortcode_atts([
            'color' => 'yellow'
        ], $atts);
        
        $colors = [
            'yellow' => '#fff3cd',
            'blue' => '#cfe2ff',
            'green' => '#d1e7dd',
            'red' => '#f8d7da'
        ];
        
        $bg_color = $colors[$atts['color']] ?? $colors['yellow'];
        
        return '<span class="dima-highlight" style="background: ' . esc_attr($bg_color) . '; padding: 2px 6px; border-radius: 3px; font-weight: 500;">' . do_shortcode($content) . '</span>';
    }
}

new Dima_Content_Blocks();