<?php
/**
 * Plugin Name: Dima WooCommerce Rial - قیمت تومان
 * Plugin URI: https://dimawidget.ir
 * Description: تبدیل قیمت ووکامرس به تومان و نمایش با فرمت ایرانی. این افزونه قیمت‌ها را به صورت خودکار به تومان تبدیل می‌کند و با اعداد فارسی نمایش می‌دهد.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-woo-rial
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * Requires Plugins: woocommerce
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Woo_Rial {
    
    public function __construct() {
        add_action('plugins_loaded', [$this, 'init']);
    }
    
    public function init() {
        if (!class_exists('WooCommerce')) {
            add_action('admin_notices', [$this, 'woocommerce_missing_notice']);
            return;
        }
        
        // Set currency to IRR
        add_filter('woocommerce_currency', [$this, 'set_currency']);
        add_filter('woocommerce_currency_symbol', [$this, 'set_currency_symbol'], 10, 2);
        add_filter('woocommerce_price_format', [$this, 'set_price_format'], 10, 2);
        add_filter('formatted_woocommerce_price', [$this, 'format_price_persian'], 10, 5);
        
        // Add thousand separator
        add_filter('wc_price_args', [$this, 'add_price_args']);
    }
    
    public function woocommerce_missing_notice() {
        echo '<div class="error"><p>افزونه Dima WooCommerce Rial نیاز به WooCommerce دارد.</p></div>';
    }
    
    public function set_currency($currency) {
        return 'IRR';
    }
    
    public function set_currency_symbol($symbol, $currency) {
        if ($currency === 'IRR') {
            return 'تومان';
        }
        return $symbol;
    }
    
    public function set_price_format($format, $currency_pos) {
        return '%2$s %1$s'; // Price Symbol (RTL)
    }
    
    public function format_price_persian($formatted_price, $price, $args) {
        $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        
        return str_replace($english_numbers, $persian_numbers, $formatted_price);
    }
    
    public function add_price_args($args) {
        $args['thousand_separator'] = '،';
        $args['decimal_separator'] = '.';
        return $args;
    }
}

new Dima_Woo_Rial();