<?php
/**
 * Plugin Name: Dima Breadcrumbs - مسیر راهبری
 * Plugin URI: https://dimawidget.ir
 * Description: نمایش مسیر راهبری (Breadcrumbs) فارسی برای بهبود SEO و تجربه کاربری. این افزونه یک breadcrumb زیبا و قابل تنظیم اضافه می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-breadcrumbs
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Breadcrumbs {
    
    public function __construct() {
        add_action('wp_head', [$this, 'add_breadcrumbs_schema']);
    }
    
    /**
     * Generate breadcrumbs HTML
     */
    public static function render($args = []) {
        $defaults = [
            'separator' => ' / ',
            'home_text' => 'خانه',
            'show_home' => true
        ];
        $args = wp_parse_args($args, $defaults);
        
        $breadcrumbs = [];
        
        if ($args['show_home']) {
            $breadcrumbs[] = '<a href="' . home_url() . '">' . $args['home_text'] . '</a>';
        }
        
        if (is_category()) {
            $category = get_queried_object();
            $breadcrumbs[] = '<span>' . esc_html($category->name) . '</span>';
        } elseif (is_single()) {
            $categories = get_the_category();
            if (!empty($categories)) {
                $breadcrumbs[] = '<a href="' . get_category_link($categories[0]->term_id) . '">' . esc_html($categories[0]->name) . '</a>';
            }
            $breadcrumbs[] = '<span>' . get_the_title() . '</span>';
        } elseif (is_page()) {
            $breadcrumbs[] = '<span>' . get_the_title() . '</span>';
        } elseif (is_search()) {
            $breadcrumbs[] = '<span>جستجو: ' . get_search_query() . '</span>';
        }
        
        if (!empty($breadcrumbs)) {
            echo '<nav class="dima-breadcrumbs" aria-label="مسیر راهبری">';
            echo '<div class="dima-breadcrumbs-inner">';
            echo implode($args['separator'], $breadcrumbs);
            echo '</div>';
            echo '</nav>';
        }
    }
    
    /**
     * Add breadcrumbs schema
     */
    public function add_breadcrumbs_schema() {
        if (is_singular()) {
            $schema = [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => []
            ];
            
            $position = 1;
            $schema['itemListElement'][] = [
                '@type' => 'ListItem',
                'position' => $position++,
                'name' => 'خانه',
                'item' => home_url()
            ];
            
            if (is_single()) {
                $categories = get_the_category();
                if (!empty($categories)) {
                    $schema['itemListElement'][] = [
                        '@type' => 'ListItem',
                        'position' => $position++,
                        'name' => $categories[0]->name,
                        'item' => get_category_link($categories[0]->term_id)
                    ];
                }
            }
            
            $schema['itemListElement'][] = [
                '@type' => 'ListItem',
                'position' => $position,
                'name' => get_the_title(),
                'item' => get_permalink()
            ];
            
            echo '<script type="application/ld+json">' . json_encode($schema, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . '</script>' . "\n";
        }
    }
}

new Dima_Breadcrumbs();

// Shortcode for breadcrumbs
add_shortcode('dima_breadcrumbs', ['Dima_Breadcrumbs', 'render']);