<?php
/**
 * Plugin Name: Dima SEO Meta - متا تگ‌های SEO
 * Plugin URI: https://dimawidget.ir
 * Description: افزودن متا تگ‌های SEO به وردپرس. این افزونه به صورت خودکار متا تگ‌های description، keywords و Open Graph را به صفحات اضافه می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-seo-meta
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_SEO_Meta {
    
    public function __construct() {
        add_action('wp_head', [$this, 'add_meta_tags']);
        add_action('admin_menu', [$this, 'add_admin_menu']);
        add_action('admin_init', [$this, 'register_settings']);
    }
    
    /**
     * Add admin menu
     */
    public function add_admin_menu() {
        add_options_page(
            'تنظیمات SEO',
            'SEO Meta',
            'manage_options',
            'dima-seo-meta',
            [$this, 'render_settings_page']
        );
    }
    
    /**
     * Register settings
     */
    public function register_settings() {
        register_setting('dima_seo_settings', 'dima_seo_default_description');
        register_setting('dima_seo_settings', 'dima_seo_default_keywords');
        register_setting('dima_seo_settings', 'dima_seo_facebook_app_id');
    }
    
    /**
     * Render settings page
     */
    public function render_settings_page() {
        ?>
        <div class="wrap">
            <h1>تنظیمات SEO Meta</h1>
            <form method="post" action="options.php">
                <?php settings_fields('dima_seo_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th><label for="dima_seo_default_description">توضیحات پیش‌فرض</label></th>
                        <td>
                            <textarea id="dima_seo_default_description" name="dima_seo_default_description" 
                                      class="large-text" rows="3"><?php echo esc_textarea(get_option('dima_seo_default_description', '')); ?></textarea>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="dima_seo_default_keywords">کلمات کلیدی پیش‌فرض</label></th>
                        <td>
                            <input type="text" id="dima_seo_default_keywords" name="dima_seo_default_keywords" 
                                   value="<?php echo esc_attr(get_option('dima_seo_default_keywords', '')); ?>" 
                                   class="large-text" placeholder="کلمه کلیدی 1, کلمه کلیدی 2">
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }
    
    /**
     * Add meta tags to head
     */
    public function add_meta_tags() {
        if (is_singular()) {
            global $post;
            $description = get_post_meta($post->ID, '_dima_seo_description', true);
            if (empty($description)) {
                $description = get_option('dima_seo_default_description', '');
                if (empty($description)) {
                    $description = wp_trim_words(get_the_excerpt(), 25);
                }
            }
            
            $keywords = get_post_meta($post->ID, '_dima_seo_keywords', true);
            if (empty($keywords)) {
                $keywords = get_option('dima_seo_default_keywords', '');
            }
            
            if (!empty($description)) {
                echo '<meta name="description" content="' . esc_attr($description) . '">' . "\n";
                echo '<meta property="og:description" content="' . esc_attr($description) . '">' . "\n";
            }
            
            if (!empty($keywords)) {
                echo '<meta name="keywords" content="' . esc_attr($keywords) . '">' . "\n";
            }
            
            // Open Graph
            echo '<meta property="og:title" content="' . esc_attr(get_the_title()) . '">' . "\n";
            echo '<meta property="og:type" content="article">' . "\n";
            echo '<meta property="og:url" content="' . esc_url(get_permalink()) . '">' . "\n";
            
            if (has_post_thumbnail()) {
                $image = wp_get_attachment_image_src(get_post_thumbnail_id(), 'large');
                if ($image) {
                    echo '<meta property="og:image" content="' . esc_url($image[0]) . '">' . "\n";
                }
            }
        }
    }
}

new Dima_SEO_Meta();