<?php
/**
 * Plugin Name: Dima Tehran Time - ساعت تهران
 * Plugin URI: https://dimawidget.ir
 * Description: نمایش ساعت و تاریخ تهران در ویدجت. این افزونه یک ویدجت زیبا برای نمایش ساعت و تاریخ تهران اضافه می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-tehran-time
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Tehran_Time_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'dima_tehran_time',
            'ساعت تهران',
            ['description' => 'نمایش ساعت و تاریخ تهران']
        );
    }
    
    public function widget($args, $instance) {
        echo $args['before_widget'];
        
        if (!empty($instance['title'])) {
            echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        }
        
        $timezone = new DateTimeZone('Asia/Tehran');
        $datetime = new DateTime('now', $timezone);
        $time = $datetime->format('H:i:s');
        $date = $datetime->format('Y/m/d');
        
        ?>
        <div class="dima-tehran-time-widget" style="text-align: center; padding: 20px;">
            <div style="font-size: 32px; font-weight: bold; color: #667eea; margin-bottom: 10px;">
                <?php echo $time; ?>
            </div>
            <div style="font-size: 16px; color: #666;">
                <?php echo $date; ?>
            </div>
            <div style="font-size: 14px; color: #999; margin-top: 5px;">
                تهران، ایران
            </div>
        </div>
        <?php
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'ساعت تهران';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">عنوان:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" 
                   name="<?php echo $this->get_field_name('title'); ?>" 
                   type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }
    
    public function update($new_instance, $old_instance) {
        $instance = [];
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        return $instance;
    }
}

function register_dima_tehran_time_widget() {
    register_widget('Dima_Tehran_Time_Widget');
}
add_action('widgets_init', 'register_dima_tehran_time_widget');