<?php
/**
 * Plugin Name: Dima Persian Numbers - اعداد فارسی
 * Plugin URI: https://dimawidget.ir
 * Description: تبدیل تمام اعداد انگلیسی به فارسی در وردپرس. این افزونه تمام اعداد را در محتوا، تاریخ و قیمت‌ها به اعداد فارسی تبدیل می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-persian-numbers
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Persian_Numbers {
    
    public function __construct() {
        add_filter('the_content', [$this, 'convert_numbers']);
        add_filter('the_title', [$this, 'convert_numbers']);
        add_filter('the_excerpt', [$this, 'convert_numbers']);
        add_filter('widget_text', [$this, 'convert_numbers']);
        add_filter('get_the_date', [$this, 'convert_numbers']);
        add_filter('get_the_time', [$this, 'convert_numbers']);
    }
    
    /**
     * Convert English numbers to Persian
     */
    public function convert_numbers($content) {
        if (empty($content)) {
            return $content;
        }
        
        $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        
        return str_replace($english_numbers, $persian_numbers, $content);
    }
}

new Dima_Persian_Numbers();