<?php
/**
 * Plugin Name: Dima WhatsApp Contact - تماس واتساپ
 * Plugin URI: https://dimawidget.ir
 * Description: افزودن دکمه شناور تماس واتساپ به سایت. این افزونه یک دکمه زیبا و قابل تنظیم برای تماس از طریق واتساپ اضافه می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-whatsapp-contact
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_WhatsApp_Contact {
    
    private $phone_number;
    private $message;
    private $position;
    
    public function __construct() {
        $this->phone_number = get_option('dima_whatsapp_phone', '989123456789');
        $this->message = get_option('dima_whatsapp_message', 'سلام، می‌خواهم با شما تماس بگیرم');
        $this->position = get_option('dima_whatsapp_position', 'bottom-left');
        
        add_action('wp_footer', [$this, 'render_button']);
        add_action('admin_menu', [$this, 'add_admin_menu']);
        add_action('admin_init', [$this, 'register_settings']);
    }
    
    /**
     * Add admin menu
     */
    public function add_admin_menu() {
        add_options_page(
            'تنظیمات واتساپ',
            'واتساپ تماس',
            'manage_options',
            'dima-whatsapp',
            [$this, 'render_settings_page']
        );
    }
    
    /**
     * Register settings
     */
    public function register_settings() {
        register_setting('dima_whatsapp_settings', 'dima_whatsapp_phone');
        register_setting('dima_whatsapp_settings', 'dima_whatsapp_message');
        register_setting('dima_whatsapp_settings', 'dima_whatsapp_position');
    }
    
    /**
     * Render settings page
     */
    public function render_settings_page() {
        ?>
        <div class="wrap">
            <h1>تنظیمات دکمه واتساپ</h1>
            <form method="post" action="options.php">
                <?php settings_fields('dima_whatsapp_settings'); ?>
                <table class="form-table">
                    <tr>
                        <th><label for="dima_whatsapp_phone">شماره واتساپ</label></th>
                        <td>
                            <input type="text" id="dima_whatsapp_phone" name="dima_whatsapp_phone" 
                                   value="<?php echo esc_attr($this->phone_number); ?>" 
                                   class="regular-text" placeholder="989123456789">
                            <p class="description">شماره را با کد کشور وارد کنید (بدون +)</p>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="dima_whatsapp_message">پیام پیش‌فرض</label></th>
                        <td>
                            <textarea id="dima_whatsapp_message" name="dima_whatsapp_message" 
                                      class="large-text" rows="3"><?php echo esc_textarea($this->message); ?></textarea>
                        </td>
                    </tr>
                    <tr>
                        <th><label for="dima_whatsapp_position">موقعیت دکمه</label></th>
                        <td>
                            <select id="dima_whatsapp_position" name="dima_whatsapp_position">
                                <option value="bottom-left" <?php selected($this->position, 'bottom-left'); ?>>پایین چپ</option>
                                <option value="bottom-right" <?php selected($this->position, 'bottom-right'); ?>>پایین راست</option>
                            </select>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }
    
    /**
     * Render WhatsApp button
     */
    public function render_button() {
        $phone = esc_attr($this->phone_number);
        $message = urlencode($this->message);
        $position_class = $this->position === 'bottom-right' ? 'right-6' : 'left-6';
        
        ?>
        <style>
            .dima-whatsapp-btn {
                position: fixed;
                bottom: 20px;
                z-index: 9999;
                width: 60px;
                height: 60px;
                background: #25D366;
                border-radius: 50%;
                display: flex;
                align-items: center;
                justify-content: center;
                box-shadow: 0 4px 12px rgba(37, 211, 102, 0.4);
                transition: all 0.3s;
                text-decoration: none;
            }
            .dima-whatsapp-btn:hover {
                transform: scale(1.1);
                box-shadow: 0 6px 20px rgba(37, 211, 102, 0.6);
            }
            .dima-whatsapp-btn i {
                font-size: 32px;
                color: white;
            }
        </style>
        <a href="https://wa.me/<?php echo $phone; ?>?text=<?php echo $message; ?>" 
           target="_blank" 
           class="dima-whatsapp-btn <?php echo $position_class; ?>"
           title="تماس از طریق واتساپ">
            <i class="fab fa-whatsapp"></i>
        </a>
        <?php
    }
}

new Dima_WhatsApp_Contact();