<?php
/**
 * Plugin Name: Dima Rial Currency - قیمت به تومان
 * Plugin URI: https://dimawidget.ir
 * Description: تبدیل قیمت‌های ووکامرس به تومان و نمایش با فرمت ایرانی. این افزونه قیمت‌ها را به صورت خودکار به تومان تبدیل می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-rial-currency
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Rial_Currency {
    
    public function __construct() {
        add_filter('woocommerce_currency_symbol', [$this, 'change_currency_symbol'], 10, 2);
        add_filter('woocommerce_price_format', [$this, 'change_price_format'], 10, 2);
        add_filter('formatted_woocommerce_price', [$this, 'format_price_persian'], 10, 5);
    }
    
    /**
     * Change currency symbol to تومان
     */
    public function change_currency_symbol($currency_symbol, $currency) {
        if ($currency === 'IRR' || $currency === 'IRT') {
            return 'تومان';
        }
        return $currency_symbol;
    }
    
    /**
     * Change price format for RTL
     */
    public function change_price_format($format, $currency_pos) {
        return '%2$s %1$s'; // Price Symbol (RTL format)
    }
    
    /**
     * Format price with Persian numbers
     */
    public function format_price_persian($formatted_price, $price, $args) {
        $persian_numbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
        $english_numbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        
        return str_replace($english_numbers, $persian_numbers, $formatted_price);
    }
}

if (class_exists('WooCommerce')) {
    new Dima_Rial_Currency();
}