<?php
/**
 * Plugin Name: Dima Persian Date - تاریخ شمسی
 * Plugin URI: https://dimawidget.ir
 * Description: تبدیل تاریخ میلادی به شمسی در وردپرس. این افزونه تمام تاریخ‌های وردپرس را به صورت خودکار به تاریخ شمسی تبدیل می‌کند.
 * Version: 1.0.0
 * Author: Dima
 * Author URI: https://dimawidget.ir
 * Text Domain: dima-persian-date
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

if (!defined('ABSPATH')) {
    exit;
}

class Dima_Persian_Date {
    
    public function __construct() {
        add_filter('get_the_date', [$this, 'convert_to_persian'], 10, 3);
        add_filter('get_the_time', [$this, 'convert_to_persian'], 10, 3);
        add_filter('the_date', [$this, 'convert_to_persian'], 10, 3);
        add_filter('the_time', [$this, 'convert_to_persian'], 10, 3);
    }
    
    /**
     * Convert Gregorian date to Persian (Jalali)
     */
    public function convert_to_persian($the_date, $format = '', $post = null) {
        if (empty($the_date)) {
            return $the_date;
        }
        
        // Simple Persian date conversion
        $timestamp = is_numeric($the_date) ? $the_date : strtotime($the_date);
        if (!$timestamp) {
            return $the_date;
        }
        
        $persian_date = $this->gregorian_to_persian($timestamp);
        
        return $persian_date;
    }
    
    /**
     * Convert Gregorian timestamp to Persian date
     */
    private function gregorian_to_persian($timestamp) {
        $date = getdate($timestamp);
        $gy = $date['year'];
        $gm = $date['mon'];
        $gd = $date['mday'];
        
        $g_d_m = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334];
        $jy = ($gy <= 1600) ? 0 : 979;
        $gy -= ($gy <= 1600) ? 621 : 1600;
        $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
        $days = (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) - 80 + $gd + $g_d_m[$gm - 1];
        $jy += 33 * ((int)($days / 12053));
        $days %= 12053;
        $jy += 4 * ((int)($days / 1461));
        $days %= 1461;
        $jy += (int)(($days - 1) / 365);
        
        if ($days > 365) {
            $days = ($days - 1) % 365;
        }
        
        $jm = ($days < 186) ? 1 + (int)($days / 31) : 7 + (int)(($days - 186) / 30);
        $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
        
        $persian_months = ['فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'];
        $persian_days = ['یکشنبه', 'دوشنبه', 'سه‌شنبه', 'چهارشنبه', 'پنج‌شنبه', 'جمعه', 'شنبه'];
        
        $day_name = $persian_days[$date['wday']];
        $month_name = $persian_months[$jm - 1];
        
        return sprintf('%s، %d %s %d', $day_name, $jd, $month_name, $jy);
    }
}

new Dima_Persian_Date();