<?php
/**
 * Plugin Name: دیما بک اپ
 * Plugin URI: https://www.dimagroup.ir/pugin/dima-backup
 * Description: بک اپ گیری از داده های وردپرس با جیسون
 * Version: 1.0.0
 * Author: روح الله بلوردی
 * Author URI: https://www.dimagroup.ir
 * Text Domain: dima-backup
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Update URI: https://dimawidget.ir/update-api.php
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('dima-backup_VERSION', '1.0.0');
define('dima-backup_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('dima-backup_PLUGIN_URL', plugin_dir_url(__FILE__));
define('dima-backup_PLUGIN_FILE', __FILE__);

/**
 * Main Plugin Class
 */
class dima-backup_Plugin {
    
    /**
     * Instance
     */
    private static $instance = null;
    
    /**
     * Get instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Constructor
     */
    private function __construct() {
        $this->init();
    }
    
    /**
     * Initialize plugin
     */
    private function init() {
        // Load text domain
        add_action('plugins_loaded', array($this, 'load_textdomain'));
        
        // Add your hooks and filters here
        // add_action('init', array($this, 'your_function'));
    }
    
    /**
     * Load text domain
     */
    public function load_textdomain() {
        load_plugin_textdomain(
            'dima-backup',
            false,
            dirname(plugin_basename(__FILE__)) . '/languages'
        );
    }
}

// Initialize plugin
function dima-backup_init() {
    return dima-backup_Plugin::get_instance();
}

// Start the plugin
dima-backup_init();